/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/


#ifndef B_PCI_H_INCLUDED
#define B_PCI_H_INCLUDED

#define DATE_BUFFER_SIZE  (sizeof(__DATE__) + 1)

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

#define ACCESS_CMD      0x54
#define ACCESS_DATA     0x58
#define ACCESS_STAT     0x5C
#define PCI_BIOS_PRESENT        0xb101
#define FIND_PCI_DEVICE         0xb102
#define FIND_PCI_CLASS_CODE     0xb103
#define GENERATE_SPECIAL_CYCLE  0xb106
#define READ_CONFIG_BYTE        0xb108
#define READ_CONFIG_WORD        0xb109
#define READ_CONFIG_DWORD       0xb10a
#define WRITE_CONFIG_BYTE       0xb10b
#define WRITE_CONFIG_WORD       0xb10c
#define WRITE_CONFIG_DWORD      0xb10d

/* this struct must be defined up here so everyone (DOS, LINUX... sees
   it) */

typedef struct {
  unsigned long m_lowPart;
  unsigned long m_highPart;
} SPhysicalAddress;

// special sub-commands for IOCTL_BEST_NTMEM_IO_ACCESS
#define BEST_NTMEM_IO_READ_BYTE   1
#define BEST_NTMEM_IO_READ_WORD   2
#define BEST_NTMEM_IO_READ_DWORD  3
#define BEST_NTMEM_IO_WRITE_BYTE  4
#define BEST_NTMEM_IO_WRITE_WORD  5
#define BEST_NTMEM_IO_WRITE_DWORD 6

#define PCI_CONNECTION_CLOSED   0

#define PCI_MAX_LEN_PER_BLOCK  127

/* User Space Config. Register Map (2925A ONLY) */

/*
// Offset       Byte3       Byte2       Byte1       Byte0
//          ================================================
// 0x40     |        main data transfer register            |
//          ================================================
// 0x44     |     **    |     **    |     **    | status    |
//          ================================================
// 0x48     |     **    |     **    | con. stat | connect   |
//          ================================================
// 0x4c     |     **    |     **    |     **    | mailbox   |
//          ================================================
// 0x50     |     **    |     **    |     **    | mbox_stat |
//          ================================================
// 0x54     |     **    |     **    |     **    | int. stat |
//          ================================================
*/

#define PCI_DATA                    0x40UL  /* writing to Byte0 sets status */

#define PCI_STATUS                  0x44UL  /* basically set by card */
#define PCI_STATUS_SEND_FULL_BIT    0x00000001UL  /* Wait for 0 (OK to write) */
#define PCI_STATUS_DATA_VALID_BIT   0x00000002UL  /* MUST write to clear
                                                   * after read */

#define PCI_CONNECT_CMD             0x48UL

#define PCI_CONNECT_STATUS          0x48UL  /* connect acknowledge */
#define PCI_CONNECT_CMD_BIT         0x00000001UL  /* write 1 to connect */
#define PCI_CONNECT_STATUS_BIT      0x00000100UL  /* 1 = connected */

#define PCI_MBOX_DATA               0x4CUL  /* writing to Byte0 sets status */

#define PCI_MBOX_STATUS             0x50UL  /* set by card */
#define PCI_MBOX_SEND_FULL_BIT      0x00000001UL  /* Wait for 0 (OK to write) */
#define PCI_MBOX_DATA_VALID_BIT     0x00000002UL  /* MUST write to clear
                                                   * after read */

/* determining if a device is multi-function */
#define PCI_MF_OFFSET               0x0CUL
#define PCI_MF_BIT                  (0x01UL << 23)

#if (!defined (_DOS) && !defined(UNIX)) || defined(LINUX)

// **************************************************************************
// NOTE; ntddk.h will NOT compile under VC++ so get rid of all the stuff
// that we don't need in the C-API.  DEVL is defined in the make file for
// the driver

#if (DEVL == 1)
#   define _DDK_BUILD
#endif

#ifndef LINUX
#  ifdef  _DDK_BUILD
#     if (_WIN32_WINNT >= 0x0501)
#       include <wdm.h>
#     else
#       include <ntddk.h>
#     endif
#     include <devioctl.h>
#     define _T(x)      L ## x
#  else
#     include <tchar.h>
#  endif
#endif /* LINUX */

#include <b_ioctl.h>    // IOCTL interface definitions (%VOBDIR%\ntdrv\include)
#include <timeout.h>   // SCR; timeouts added 26.11.97


/*************************************
 * defines etc. for memory-driver...
 *************************************/




/*************************************
 * defines etc. for pci-driver...
 *************************************/

#ifndef LINUX

// ** we also need g:\cvts\include in the path for xtypedef.h **

// SCRobinson; 
// Modified 5/97 to build multiple device objects.
// Each PCI FUNCTION (All vendors !!!) has one corresponding device object.
// Details of each PCI Device/Function are stored in the Registry (see below);

////////////////////// **** VERSION CHANGES **** ///////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Change the following 3 items to get a different version of the driver
// that will CO-EXIST with all previous versions

// The version/date is manual and MUST be changed whenever this file
// is recompiled.
// NOTE; Change BEST_PCI_DRIVER and HPBEST_DEVICES_PATH as well if the new
//       version can coexist...else just DEV_VERSION. 

// 23.2.98; version 4.## is B

#define DEV_VERSION  _T("2.00 (C), Aug 15, 2000")

// Driver Name
#define BEST_PCI_DRIVER         _T("BestNTPci_C")

// The subkey for all HP Best devices
#define HPBEST_DEVICES_PATH     _T("AGILENT_BEST_DEVICES_C")
// Driver Name


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

// The subkey under HPBEST_DEVICES_PATH for each device object
#define REG_BASE_DEVICE_NAME _T("BestPci")

// *** The FULL registry paths ***
// The subkey for all HP Best devices when using reg. functions from the C-API
#define CAPI_HPBEST_DEVICES_PATH _T("Hardware\\DeviceMap\\" HPBEST_DEVICES_PATH)

// i.e. HKEY_LOCAL_MACHINE\HARDWARE\DEVICEMAP
#define DRVR_HPBEST_DEVICES_PATH _T("\\Registry\\Machine\\" CAPI_HPBEST_DEVICES_PATH)

// ********************************************************************************
// 13 May '97; SCR.  
// The Driver will attach a 0,1 etc. after each of these base names to identify
// individual devices.

// BASE NT device name ... 
#define BASE_NTIO_DEVICE_NAME_PCI  _T("\\Device\\" BEST_PCI_DRIVER)

// BASE symbolic link string for Win32 
#define BASE_DOS_DEVICE_NAME_PCI _T("\\DosDevices\\Agilent" BEST_PCI_DRIVER)

// BASE name (lpFileName) for call to CreateFile()
#define BASE_CREATE_FILE_NAME_PCI _T("\\\\.\\Agilent" BEST_PCI_DRIVER)

// There is one common subkey for all devices (REG_BASE_DEVICE_NAME)
// which has the following values
#define VALUENAME_VERSION _T("Version")
#define VALUENAME_DEV_COUNT _T("DeviceCount")

#define DEV_ENUM_COMMON    0xFFFF
#define DEV_ENUM_NOT_FOUND      0xFFFE

// There is one subkey for each device (REG_BASE_DEVICE_NAME + #)
// which has the following values
#define VALUENAME_DEVICENAME _T("Name")
#define VALUENAME_HPSLOTID  _T("HPSlotID")
#define VALUENAME_BUSNUM  _T("BusNumber")
#define VALUENAME_SLOTNUM  _T("SlotNumber")
#define VALUENAME_FUNCNUM  _T("FunctionNumber")
#define VALUENAME_VENDORID  _T("VendorID")
#define VALUENAME_DEVICEID  _T("DeviceID")
#define VALUENAME_OWNERID  _T("OwnerID")
#define VALUENAME_MAPIOADDR  _T("MappedIOAddress")
#define VALUENAME_DECODERSTAT _T("DecoderStatus")

#define BACK_SLASH              _T("\\")

#endif /* LINUX */


#define INVALID_HPSLOTID        0xFFFFFFFF
#define INVALID_BASE_IOADDR     0xFFFFFFFF
#define INVALID_DATA            0xFFFFFFFF
#define	DEVICE_HAS_NO_OWNER		0xFFFFFFFF
#define	DEVICE_OWNER_UNKNOWN    0xFFFFFFFE

// These are "our" vendor codes
enum {
  HP_VENDOR_ID	    =  0x103c,	/* "old" HP vendor ID */
  AGILENT_VENDOR_ID =  0x15bc	/* Agilent vendor ID */
};

enum {
  /* "old" PCI cards: */
  HP_DEVICE_2925      = 0x2925,
  HP_DEVICE_2926      = 0x2926,
  HP_DEVICE_2927      = 0x2927,
  HP_DEVICE_2928      = 0x2928,
  HP_DEVICE_2940      = 0x2940,

  /* for PCI-X cards: new Device IDs */
  AGILENT_DEVICE_2922 =  0x2922, /* E2922A */
  AGILENT_DEVICE_2929 =  0x2929, /* E2929A */
  AGILENT_DEVICE_2923 =  0x2923, /* E2923A */
  AGILENT_DEVICE_2930 =  0x2930, /* E2930A */
};

// SCR; 27.3.98; This structure created to provide extended debug info
// regarding the MPS 1.4 problem.
typedef struct _MPS_INFO
{
  void * virt_addr;   // old return value
  ULONG ntStatus;     // HAL error code
  ULONG driverErr;    // Best error code
} MPS_INFO, *PMPS_INFO;

#ifndef  _DDK_BUILD
//
// A couple of typedefs b_ntmem.h depends on from  NTDDK.H.
// NTDDK.H can not be included in user-mode
//
typedef enum _INTERFACE_TYPE {
    InterfaceTypeUndefined = -1,
    Internal,
    Isa,
    Eisa,
    MicroChannel,
    TurboChannel,
    PCIBus,
    VMEBus,
    NuBus,
    PCMCIABus,
    CBus,
    MPIBus,
    MPSABus,
    ProcessorInternal,
    InternalPowerBus,
    PNPISABus,
    MaximumInterfaceType
}INTERFACE_TYPE, *PINTERFACE_TYPE;

#ifndef LINUX
typedef LARGE_INTEGER PHYSICAL_ADDRESS;
#endif

#endif /* ndef DDK_BUILD */


/*------------------- enhanced allocation/deallocation of buffers -----------*/
typedef struct _MAP_MEM_ALLOC_MEM
{
    SPhysicalAddress physical_address;
    PVOID virtual_address;
    size_t Length;
} MAP_MEM_ALLOC_MEM, *PMAP_MEM_ALLOC_MEM;

//
// Our user mode app will pass an initialized structure like this
//     down to the kernel mode driver
//
typedef struct
{
    INTERFACE_TYPE   InterfaceType; // Isa, Eisa, etc....
    ULONG            BusNumber;     // Bus number
    PHYSICAL_ADDRESS BusAddress;    // Bus-relative address
    ULONG            AddressSpace;  // 0 is memory, 1 is I/O
    ULONG            Length;        // Length of section to map

} PHYSICAL_MEMORY_INFO, *PPHYSICAL_MEMORY_INFO;

// Special (to HP/Agilent) structure used at the application level (C-API)
typedef struct _HP_SLOT_ID {
    union {
        struct {
            ULONG   FunctionNumber:3;
            ULONG   DeviceNumber:5;
            ULONG   BusNumber:8;
			ULONG	Reserved:16;
        } bits;
        ULONG   AsULONG;
    } u;
} HP_SLOT_ID, *PHP_SLOT_ID;

#if defined(_DDK_BUILD) || defined(__KERNEL__)

// Debug printing

#if DBG
#define DBG_PRINT(arg) (void)DbgPrint arg
#else
#define DBG_PRINT(arg)
#endif

// 20Aug98; Special hack for Henrik's problem with a fast computer
// (400 MHz ... 2926 get interrupt-bound?)
#define WASTE_TIME 0

#if WASTE_TIME
# define WASTE_SOME_TIME   PciWasteTime()
# define NUM_uS_TO_WASTE   50
  void PciWasteTime(void);
#else
# define WASTE_SOME_TIME
#endif


// Allowable register widths.  Note that we take a short cut here
// with DATA_WIDTH_ODD for speed reasons....if these values 
// actually change (i.e. adding 64 bit) then you need to look at 
// PciSetDataWidth().
#define DATA_WIDTH_UCHAR   sizeof(UCHAR)
#define DATA_WIDTH_USHORT  sizeof(USHORT)
#define DATA_WIDTH_ULONG   sizeof(ULONG)
#define DATA_WIDTH_ODD     3  

// For init. of timeouts
static BESTTIMEOUTS defTimeouts = NO_TIMEOUTS;

// for access port
#define ACCESSPORT_CMD_ADDRESS		0x54UL
#define ACCESSPORT_CMD_READ		0x01UL
#define ACCESSPORT_CMD_SIZE_BYTE	0x01UL << 1
#define ACCESSPORT_CMD_SIZE_WORD	0x02UL << 1
#define ACCESSPORT_CMD_SIZE_DWORD	0x00UL << 1
#define ACCESSPORT_CMD_SIZE_RESERVED	0x02UL << 1

#define ACCESSPORT_DATA			0x58UL

#define ACCESSPORT_STAT			0x5cUL
#define ACCESSPORT_STAT_PORT_RDY	0x01UL
#define ACCESSPORT_STAT_DATA_RDY	0x02UL



// ********************************************************************************

// defines for direct I/O
#define IO_ACCESS_ENABLED   0x0001

#define IO_BEST_REG_NUM     2                   // which base addr. register ?

#define IO_SPACE            0x00000001UL        // bit 0 set if base addr. in I/O space
#define IO_BASE_ADDR_MASK   0xFFFFFFFCUL        // ignore bottom 2 bits

// The mapped I/O base address starts at the end ofthe Configuration header
#define     UNMAPPED_CONFIG_SIZE    (sizeof(ULONG) * 16)
#define     IO_XLATE(Base, Offset)      (Base - UNMAPPED_CONFIG_SIZE + Offset)

// For DecoderStatus
#define     DECODER_DISABLED    0x00000000
#define     DECODER_ENABLED     0x00000001
#define     DECODER_LOADED      0x00000002
#define     DECODER_READY       0x00000003  // enabled and loaded


#ifndef LINUX
// For initialization of unicode strings
static const UNICODE_STRING HP_NULL_UNICODE = {0, 0, NULL};
 
static PDEVICE_OBJECT mem_control_object;

typedef struct _MEMORY_LIST {
    PHYSICAL_ADDRESS physical_address;
    PVOID            user_virtual_address;
    PVOID            kernel_virtual_address;
    ULONG            size;
    PMDL             mdl;
    PEPROCESS        process;
    struct _MEMORY_LIST *prev;
    struct _MEMORY_LIST *next;
} MEMORY_LIST, *PMEMORY_LIST;

// driver local data structure specific to each device object
// 12/5/97; additional fields for multiple devices.
typedef struct _LOCAL_DEVICE_INFO {
  USHORT		  EnumDevice;				// 0 based index of this device (safety)
  USHORT          StartNumber;              // Devices was started as number ...
  ULONG           DeviceType;				// Our private Device Type
  PDEVICE_OBJECT  DeviceObject; 			// The BestNTio device object.
  USHORT          RegWidth;		   	        // register width, 1, 2 or 4
  HP_SLOT_ID	  HPSlotID;	 			    // our "special" format

  // for direct I/O read/write
  ULONG           DecoderStatus;            // Bits: DECODER_ENABLED, DECODER_LOADED
  BOOLEAN         fUsingDirectIO;           // Are we using direct I/O?

  // Base address decoded (index 2 = MINI decoder)
  // These registers are copies of PCI_COMMON_CONFIG members
  USHORT          Command;                  // .Command
  ULONG_PTR       BaseAddress;              // .u.type0.BaseAddresses[PCI_TYPE0_ADDRESSES]
  BOOLEAN         BaseMapped;               // is BaseAddress iomapped?
  ULONG           BaseAddressLength;

  // note that these are actually redundant but here for speed during read/write
  ULONG				    NTSlotID;			// PCI slot info
  ULONG				    BusNumber;			// NT Bus Number

  // N.B. This is definitely overkill but all of the uses for these devices
  //		are not yet defined so I built for any eventuality.
  PDEVICE_OBJECT    LowerDeviceObject;      // ptr to next device in Irp stack
  PDEVICE_OBJECT    PhysicalDeviceObject;   // ptr to physical device
  PDEVICE_OBJECT	PreviousDevice;		    // ptr to previous device in chain
  PDEVICE_OBJECT	NextDevice;				// ptr to next device in chain
  USHORT			NumDevices;		        // Total number of devices (??)
  BOOLEAN			fDeviceOpen;		    // device has been opened by a user-process
  BOOLEAN           fIsHPBestDevice;        // device is actually a HP Best card.
  BOOLEAN           fIs2925;                // device is a 2925
  BOOLEAN           fIs2926;                // device is a 2926

  UNICODE_STRING    ifname;
//  BUS_INTERFACE_STANDARD BusInterface;

  BESTTIMEOUTS      CommTimeouts;           /* SCR; 26.11.97 */

#if _WIN32_WINNT < 0x0500
  PADAPTER_OBJECT   DmaAdapter;
#else
  PDMA_ADAPTER      DmaAdapter;             // Used later to allocate common buffers
#endif
  ULONG             MaxDmaBufferSize;       // Maximum size of buffer

} LOCAL_DEVICE_INFO, *PLOCAL_DEVICE_INFO;


NTSTATUS PciAddCommonDeviceKey(
    IN int iDeviceCount
);

NTSTATUS PciAddEnumDeviceKey(
    PLOCAL_DEVICE_INFO pDO,
    PPCI_COMMON_CONFIG pPciData
);

ULONG PciSetDataWidth(
    ULONG ulNumBytes,   // number of bytes being read or written
    USHORT usRegWidth   // current reg. width
);

NTSTATUS PciDispatch(
				IN  PDEVICE_OBJECT pDO,
				IN  PIRP pIrp
				);

NTSTATUS PciOpen(
				IN  PDEVICE_OBJECT pDO,
				IN  PIRP pIrp
				);

NTSTATUS PciClose(
				IN  PDEVICE_OBJECT pDO,
				IN  PIRP pIrp
				);

VOID PciUnload(
				IN PDRIVER_OBJECT DriverObject 
				);


NTSTATUS PciWrite(
				IN PDEVICE_OBJECT pDeviceObject,
				IN PIRP           pIrp
				);

NTSTATUS PciWriteConfigDW(
				IN PLOCAL_DEVICE_INFO pLDI,
				IN PIRP pIrp );

NTSTATUS PciRead(
				IN PDEVICE_OBJECT pDeviceObject,
				IN PIRP           pIrp
				);

NTSTATUS PciReadConfigDW(
				IN PLOCAL_DEVICE_INFO pLDI,
				IN PIRP pIrp );

NTSTATUS
PciDirectRegRead(
  IN PLOCAL_DEVICE_INFO pLDI,
  IN PIRP pIrp);

NTSTATUS
PciDirectRegWrite(
  IN PLOCAL_DEVICE_INFO pLDI,
  IN PIRP pIrp);

void PciDisconnectBest(
				IN PLOCAL_DEVICE_INFO pLDI
				);

void PciSetupDirectIo(
				IN PLOCAL_DEVICE_INFO pLDI,
                IN PPCI_COMMON_CONFIG pPciData
                );

void PciClearRegistry(
				USHORT uiDeviceEnum
				);

NTSTATUS PciGetFullDeviceKey( 
                IN PUNICODE_STRING puniFullPath,
                IN PUSHORT puiDeviceNum
                );

// General Purpose Functions can be used with any device driver.

// *** Unicode string passed to HPAllocUnicodeString() MUST be initialized
// *** to HP_NULL_UNICODE at the time of declaration !!
// *** This allows you to safely call HPFreeUnicodeString() any number
// *** of times thereafter.

// The following definition must be in each driver using these functions
// static const UNICODE_STRING HP_NULL_UNICODE = {0,0,NULL};

NTSTATUS HPAllocUnicodeString(
				IN OUT PUNICODE_STRING pUnicodeString,
				IN PCWSTR pString1,
				IN PCWSTR pString2,
				IN PCWSTR pString3,
				IN PUSHORT pNumber
				);

void HPFreeUnicodeString( IN PUNICODE_STRING pUnicodeString );


NTSTATUS HPCreateVolatileRegKey( IN PUNICODE_STRING pFullPath );

NTSTATUS HPDeleteRegKey( IN PUNICODE_STRING pFullPath );

NTSTATUS IrpForwardAndWait(PDEVICE_OBJECT deviceObject, PIRP Irp);
NTSTATUS IrpRequestComplete(PDEVICE_OBJECT deviceObject, PIRP Irp, PKEVENT pev);
NTSTATUS IrpCompleteRequest(IN PIRP Irp, IN NTSTATUS status, IN ULONG info);
NTSTATUS IrpDefaultPnpHandler(IN PDEVICE_OBJECT fdo, IN PIRP Irp);
NTSTATUS IrpReadWriteConfigSpace(
    IN PDEVICE_OBJECT DeviceObject,
    IN ULONG	      ReadOrWrite, // 0 for read 1 for write
    IN PVOID	      Buffer,
    IN ULONG	      Offset,
    IN ULONG	      Length
    );

NTSTATUS
GetPCIBusInterfaceStandard(
    IN  PDEVICE_OBJECT DeviceObject,
    OUT PBUS_INTERFACE_STANDARD	BusInterfaceStandard
    );

NTSTATUS
MapMemMapTheMemory(
  IN PDEVICE_OBJECT DeviceObject,
  IN OUT PVOID IoBuffer,
  IN ULONG InputBufferLength,
  IN ULONG OutputBufferLength
);

NTSTATUS
AllocPhysicalMemory(
  IN PLOCAL_DEVICE_INFO pLocalInfo,
  IN PIRP pIrp,
  IN PIO_STACK_LOCATION IrpStack);

NTSTATUS
FreePhysicalMemory(
  IN PLOCAL_DEVICE_INFO pLocalInfo,
  IN PIRP pIrp,
  IN PIO_STACK_LOCATION IrpStack);

NTSTATUS
IOAccess(
  IN PIRP pIrp,
  IN PIO_STACK_LOCATION IrpStack);

#else

/********************* function prototypes ***********************************/
 
static int bestpci_open(struct inode *inode, struct file *file);
static int bestpci_close(struct inode *inode, struct file *file);
static int bestpci_write(struct file *file, const char *buf, size_t count, loff_t *ppos);
static int bestpci_read(struct file *file, char *buf, size_t count, loff_t *ppos);
static int bestpci_ioctl(struct inode *inode, struct file *file, unsigned int cmd, unsigned long arg);
 
static int bestpci_probe(struct pci_dev *dev, const struct pci_device_id *id);
static void bestpci_remove(struct pci_dev *dev);
void bestpci_disconnect(struct pci_dev *dev);
u32 bestpci_direct_reg_read(struct pci_dev *dev,b_accessporttype *pPortData);
void bestpci_direct_reg_write(struct pci_dev *dev,b_accessportdatatype *pPortData);
void bestpci_write_config_dw(struct pci_dev *dev,b_configdrivertype *data);
u32 bestpci_read_config_dw(struct pci_dev *dev,u32 data);

#endif /* LINUX */

#endif  /* #ifdef  _DDK_BUILD */

#ifdef LINUX

#include <linux/types.h>
#ifdef CUSTOM_OEM1
#include <linux/spinlock.h>
#endif

#define BESTPCI_MAJOR 123
#define DEV_VERSION "0.0.1 (C), Sep 19, 2001"
typedef struct {
  __u8             enumdevice;                          // 0 based index of this device (safety)
  __u32            devicetype;                          // Our private Device Type
  __u8             regwidth;                              // register width, 1, 2 or 4
  HP_SLOT_ID     slot_id;                                 // our "special" format
 
  // for direct I/O read/write
  __u32            decoderstatus;          // Bits: DECODER_ENABLED, DECODER_LOADED
  __u8             f_using_direct_io;         // Are we using direct I/O?
 
  // Base address decoded (index 2 = MINI decoder)
  // These registers are copies of PCI_COMMON_CONFIG members
  void           *baseaddress;      // .u.type0.BaseAddresses[PCI_TYPE0_ADDRESSES]
  __u32            baselen;
 
  // N.B. This is definitely overkill but all of the uses for these devices
  //            are not yet defined so I built for any eventuality.
  __u8             f_device_open;                       // device has been opened by a user-process
  __u8             f_is_hp_best_device;  // device is actually a HP Best card.
  __u8             f_is_2925;          // device is a 2925
  __u8             f_is_2926;          // device is a 2926
 
  __u16            device_id;
  __u16            vendor_id;
  __u16            sub_vendor_id;
  __u16            sub_device_id;
  __u16            class;
 
  BESTTIMEOUTS    commtimeouts;     /* SCR; 26.11.97 */
#ifdef CUSTOM_OEM1
  spinlock_t      lock ;
#endif
} bestpci_device_info;
 
typedef struct {
  unsigned char *version;
  int dev_count;
} bestpci_general_info;

#endif /* LINUX */

#endif /* UNIX */

#endif
